/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class JsonModelHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static void itemJson(File assetsFolder, Iterable<Item> list) {
        try {
            for (Item item : list) {
                File jsonFile = new File(assetsFolder, item.getRegistryName().func_110623_a() + ".json");
                if (jsonFile.exists()) continue;
                jsonFile.createNewFile();
                FileWriter writer = new FileWriter(jsonFile);
                JsonWriter json = GSON.newJsonWriter((Writer)writer);
                json.beginObject();
                json.name("parent");
                json.value("minecraft:item/generated");
                json.name("textures");
                json.beginObject();
                json.name("layer0");
                json.value(item.getRegistryName().func_110624_b() + ":items/" + item.getRegistryName().func_110623_a());
                json.endObject();
                json.endObject();
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void blockJson(File assetsFolder, Iterable<Block> list, @Nullable Function<Block, String> parentModel) {
        try {
            new File(assetsFolder + "/blockstates").mkdir();
            new File(assetsFolder + "/model").mkdir();
            new File(assetsFolder + "/item").mkdir();
            for (Block block : list) {
                File jsonFile3;
                File jsonFile2;
                File jsonFile = new File(assetsFolder + "/blockstates", block.getRegistryName().func_110623_a() + ".json");
                if (!jsonFile.exists()) {
                    jsonFile.createNewFile();
                    FileWriter writer = new FileWriter(jsonFile);
                    JsonWriter json = GSON.newJsonWriter((Writer)writer);
                    json.beginObject();
                    json.name("variants");
                    json.beginObject();
                    json.name("normal");
                    json.beginObject();
                    json.name("model");
                    json.value(block.getRegistryName().toString());
                    json.endObject();
                    json.endObject();
                    json.endObject();
                    writer.close();
                }
                if (!(jsonFile2 = new File(assetsFolder + "/model", block.getRegistryName().func_110623_a() + ".json")).exists()) {
                    jsonFile2.createNewFile();
                    FileWriter writer = new FileWriter(jsonFile2);
                    JsonWriter json = GSON.newJsonWriter((Writer)writer);
                    json.beginObject();
                    json.name("parent");
                    json.value(parentModel.apply(block));
                    json.name("textures");
                    json.beginObject();
                    json.name("0");
                    json.value(block.getRegistryName().func_110624_b() + ":blocks/" + block.getRegistryName().func_110623_a());
                    json.endObject();
                    json.endObject();
                    writer.close();
                }
                if ((jsonFile3 = new File(assetsFolder + "/item", block.getRegistryName().func_110623_a() + ".json")).exists()) continue;
                jsonFile3.createNewFile();
                FileWriter writer = new FileWriter(jsonFile3);
                JsonWriter json = GSON.newJsonWriter((Writer)writer);
                json.beginObject();
                json.name("parent");
                json.value(block.getRegistryName().func_110624_b() + ":block/" + block.getRegistryName().func_110623_a());
                json.endObject();
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void lang(File assetsFolder, List<Item> list) {
        try {
            File jsonFile = new File(assetsFolder, "rawItemLang.json");
            if (!jsonFile.exists()) {
                FileWriter writer = new FileWriter(jsonFile);
                BufferedWriter buf = new BufferedWriter(writer);
                for (Item item : list) {
                    buf.write(item.getRegistryName() + ".name=");
                    buf.newLine();
                }
                buf.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

